import { analyzeURL } from "./engine.js";

const analyzeBtn = document.getElementById("analyzeBtn");
const urlInput = document.getElementById("urlInput");

analyzeBtn.addEventListener("click", () => {
  const url = urlInput.value.trim();
  if (!url) return;

  const result = analyzeURL(url);

  document.getElementById("result").classList.remove("hidden");

  const verdictEl = document.getElementById("verdict");
  const scoreFill = document.getElementById("scoreFill");
  const explanationEl = document.getElementById("explanation");
  const reasonsEl = document.getElementById("reasons");

  verdictEl.textContent = `${result.verdict} (${result.score})`;
  explanationEl.textContent = result.explanation;

  scoreFill.style.width = Math.min(result.score, 100) + "%";
  scoreFill.style.background =
    result.verdict === "SAFE" ? "#2ecc71" :
    result.verdict === "WARNING" ? "#f1c40f" :
    "#e74c3c";

  reasonsEl.innerHTML = "";
  result.reasons.forEach(reason => {
    const li = document.createElement("li");
    li.textContent = reason;
    reasonsEl.appendChild(li);
  });
});
